package com.ejie.ab04b.service;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.StringTokenizer;

import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejie.ab04b.constantes.ConstantesDocumentos;
import com.ejie.ab04b.constantes.ConstantesNum;
import com.ejie.ab04b.exception.AB04BException;
import com.ejie.ab04b.model.VenvioOs2;
import com.ejie.ab04b.util.CaracteresRarosUtil;
import com.ejie.ab04b.util.Utilities;

/**
 * GeneracionPDFCartaAperturaImpl generated by UDA, 11-Jan-2017 12:23:08.
 * 
 * @author UDA
 */

@Service(value = "generacionPDFComunicacionOS2Impl")
public class GeneracionPDFComunicacionOS2Impl implements
		GeneracionPDFComunicacionOS2Service {

	@Autowired
	private VenvioOs2Service venvioOs2Service;

	/**
	 * Devuelve un InputStream con el documento pdf.
	 * 
	 *  listadoFolderNumber
	 *            String[]
	 *  Inputstream
	 *
	 * @param listadoFolderNumber the listado folder number
	 * @return the pdf
	 * @throws AB04BException the AB 04 B exception
	 */
	public InputStream getPDF(String[] listadoFolderNumber)
			throws AB04BException {
		try {

			String xslFichero = "";
			xslFichero = ConstantesDocumentos.COMUNICACION_OS2_XSL;

			InputStream inputStream = null;

			StringBuffer xmlPdf = getXml(listadoFolderNumber);
			String xml = CaracteresRarosUtil.htmlEscape(xmlPdf.toString());
			StringReader xmlReader = new StringReader(xml);

			// Inicializo transformer
			Transformer transformer = pdfTransformacionInit(xslFichero);
			// Ejecuto transformación
			ByteArrayOutputStream byteOut = pdfTransformacionExec(transformer,
					xmlReader, org.apache.fop.apps.Driver.RENDER_PDF);

			byte[] bytes = byteOut.toByteArray();
			inputStream = new ByteArrayInputStream(bytes);

			byteOut.close();

			return inputStream;
		} catch (Exception e) {
			throw new AB04BException(e, e.getMessage());
		}

	}

	/**
	 * Devuelve los datos para completar el xml.
	 * 
	 *  folderNumber
	 *            String
	 *  HashMap
	 *
	 * @param folderNumber the folder number
	 * @return the datos
	 */
	private HashMap getDatos(String folderNumber) {
		String folderNumberAux = folderNumber;
		String mascara = Utilities.getInstance().getDateMask();
		SimpleDateFormat sdf = new SimpleDateFormat(mascara);
		String fechaObtencion = sdf.format(new java.util.Date());
		String campoDia = fechaObtencion.substring(0, ConstantesNum.NUM_2);
		String campoMes = fechaObtencion.substring(ConstantesNum.NUM_3,
				ConstantesNum.NUM_5);
		String campoAnio = fechaObtencion.substring(ConstantesNum.NUM_6,
				ConstantesNum.NUM_10);
		String provincia = "";

		folderNumberAux = folderNumberAux.replaceAll("/", "-");

		StringTokenizer token = new StringTokenizer(folderNumberAux, "-");
		if (token.hasMoreTokens()) {
			provincia = (String) token.nextToken();
		}
		String provCast = "";
		String lugarCast = "";
		String provEusk = "";
		String lugarEusk = "";
		if ("01".equals(provincia) || "1".equals(provincia)) {
			provCast = "Alava";
			provEusk = "Araba";
			lugarCast = "Vitoria-Gasteiz";
			lugarEusk = "Vitoria-Gasteiz";
		} else if ("48".equals(provincia)) {
			provCast = "Bizkaia";
			provEusk = "Bizkaia";
			lugarCast = "Bilbao";
			lugarEusk = "Bilbo";
		} else if ("20".equals(provincia)) {
			provCast = "Gipuzkoa";
			provEusk = "Gipuzkoa";
			lugarCast = "San Sebastián";
			lugarEusk = "Donostia";
		}

		String mes = "";
		String mesEusk = "";
		switch (Integer.parseInt(campoMes)) {
		case 1: {
			mesEusk = "Urtarrila";
			mes = "Enero";
		}
			break;
		case ConstantesNum.NUM_2: {
			mesEusk = "Otsaila";
			mes = "Febrero";
		}
			break;
		case ConstantesNum.NUM_3: {
			mesEusk = "Martxoa";
			mes = "Marzo";
		}
			break;
		case ConstantesNum.NUM_4: {
			mesEusk = "Apirila";
			mes = "Abril";
		}
			break;
		case ConstantesNum.NUM_5: {
			mesEusk = "Maiatza";
			mes = "Mayo";
		}
			break;
		case ConstantesNum.NUM_6: {
			mesEusk = "Ekaina";
			mes = "Junio";
		}
			break;
		case ConstantesNum.NUM_7: {
			mesEusk = "Uztaila";
			mes = "Julio";
		}
			break;
		case ConstantesNum.NUM_8: {
			mesEusk = "Abuztua";
			mes = "Agosto";
		}
			break;
		case ConstantesNum.NUM_9: {
			mesEusk = "Iraila";
			mes = "Septiembre";
		}
			break;
		case ConstantesNum.NUM_10: {
			mesEusk = "Urria";
			mes = "Octubre";
		}
			break;
		case ConstantesNum.NUM_11: {
			mesEusk = "Azaroa";
			mes = "Noviembre";
		}
			break;
		case ConstantesNum.NUM_12: {
			mesEusk = "Abendua";
			mes = "Diciembre";
		}
			break;
		default: {
			break;
		}
		}

		HashMap datosMap = new HashMap();
		datosMap.put("anio", campoAnio);
		datosMap.put("dia", campoDia);
		datosMap.put("provinciaCast", provCast);
		datosMap.put("provinciaEusk", provEusk);
		datosMap.put("ciudadCast", lugarCast);
		datosMap.put("ciudadEusk", lugarEusk);
		datosMap.put("campoMesEusk", mesEusk);
		datosMap.put("campoMes", mes);

		return datosMap;
	}

	/**
	 * Inicializa la transformacion a PDF.
	 * 
	 *  xslFichero
	 *            String
	 *  Transformer
	 *
	 * @param xslFichero the xsl fichero
	 * @return the transformer
	 * @throws AB04BException the AB 04 B exception
	 */
	private Transformer pdfTransformacionInit(String xslFichero)
			throws AB04BException {
		try {
			TransformerFactory tFactory = TransformerFactory.newInstance();

			// org.apache.fop.configuration.Configuration.put("baseDir", "c:/");

			return tFactory.newTransformer(new StreamSource(xslFichero));
		} catch (Exception e) {
			throw new AB04BException(e, e.getMessage());
		}

	}

	/**
	 * Ejecuta la transformación PDF.
	 * 
	 *  transformer
	 *            transformer
	 *  strReader
	 *            strReader
	 *  renderer
	 *            renderer
	 *  ByteArrayOutputStream
	 *
	 * @param transformer the transformer
	 * @param strReader the str reader
	 * @param renderer the renderer
	 * @return the byte array output stream
	 * @throws AB04BException the AB 04 B exception
	 */
	private ByteArrayOutputStream pdfTransformacionExec(
			Transformer transformer, StringReader strReader, int renderer)
			throws AB04BException {
		try {
			DOMResult domResultado = new DOMResult();

			transformer.transform(new StreamSource(strReader), domResultado);

			org.apache.fop.apps.Driver driver = new org.apache.fop.apps.Driver();

			driver.setRenderer(renderer);

			ByteArrayOutputStream byteOut = new ByteArrayOutputStream();

			driver.setOutputStream(byteOut);
			driver.render((org.w3c.dom.Document) domResultado.getNode());
			driver.reset();

			return byteOut;
		} catch (Exception e) {
			throw new AB04BException(e, e.getMessage());
		}
	}

	/**
	 * Obtiene los datos y genera el XML.
	 * 
	 *  listadoFolderNumber
	 *            String[]
	 *  String
	 *
	 * @param listadoFolderNumber the listado folder number
	 * @return the xml
	 * @throws AB04BException the AB 04 B exception
	 */
	private StringBuffer getXml(String[] listadoFolderNumber)
			throws AB04BException {

		try {
			VenvioOs2 venvioOs2 = new VenvioOs2();

			StringBuffer xml = new StringBuffer();
			xml.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
			xml.append("<impresiones>");
			for (int i = 0; i < listadoFolderNumber.length; i++) {
				venvioOs2 = obtenerVenvioOs2(listadoFolderNumber[i]);
				HashMap datosMap = getDatos(listadoFolderNumber[i]);
				xml.append("<docOS2>");
				xml.append("<firma>");
				xml.append((venvioOs2.getDescfirma() != null) ? venvioOs2
						.getDescfirma() : "");
				xml.append("</firma>");
				xml.append("<fichero>");
				if (venvioOs2.getFirma() != null) {
					xml.append(ConstantesDocumentos.RUTA_FIRMA_IMAGEN).append(
							"/");
					xml.append(venvioOs2.getFirma());
				} else {
					xml.append("");
				}
				xml.append("</fichero>");
				xml.append("<anio>");
				xml.append(datosMap.get("anio"));
				xml.append("</anio>");
				xml.append("<mes>");
				xml.append(datosMap.get("campoMes"));
				xml.append("</mes>");
				xml.append("<mesEu>");
				xml.append(datosMap.get("campoMesEusk"));
				xml.append("</mesEu>");
				xml.append("<dia>");
				xml.append(datosMap.get("dia"));
				xml.append("</dia>");
				xml.append("<razonSocial>");
				xml.append((venvioOs2.getRazonsocial() != null) ? venvioOs2
						.getRazonsocial() : "");
				xml.append("</razonSocial>");
				xml.append("<DNI>");
				xml.append((venvioOs2.getNumerodocumento() != null) ? venvioOs2
						.getNumerodocumento() : "");
				xml.append("</DNI>");
				xml.append("<actividadPrincipal>");
				xml.append((venvioOs2.getDescActividadeconomica() != null) ? venvioOs2
						.getDescActividadeconomica() : "");
				xml.append("</actividadPrincipal>");
				xml.append("<CNAE>");
				xml.append((venvioOs2.getActividadeconomica() != null) ? venvioOs2
						.getActividadeconomica() : "");
				xml.append("</CNAE>");
				xml.append("<existeAnexSi>");
				xml.append((venvioOs2.getIndanxSi() != null) ? venvioOs2
						.getIndanxSi() : "");
				xml.append("</existeAnexSi>");
				xml.append("<existeAnexNo>");
				xml.append((venvioOs2.getIndanxNo() != null) ? venvioOs2
						.getIndanxNo() : "");
				xml.append("</existeAnexNo>");
				xml.append("<apartadoAnex>");
				xml.append((venvioOs2.getApdoAnexo() != null) ? venvioOs2
						.getApdoAnexo() : "");
				xml.append("</apartadoAnex>");
				xml.append("<domicilioSocial>");
				xml.append((venvioOs2.getDireccion() != null) ? venvioOs2
						.getDireccion() : "");
				xml.append("</domicilioSocial>");
				xml.append("<plantilla>");
				xml.append((venvioOs2.getPlantilla() != null) ? venvioOs2
						.getPlantilla() : "");
				xml.append("</plantilla>");
				xml.append("<territorio>");
				xml.append((venvioOs2.getTerritorioempresa() != null) ? venvioOs2
						.getTerritorioempresa() : "");
				xml.append("</territorio>");
				xml.append("<codPostal>");
				xml.append((venvioOs2.getCp() != null) ? venvioOs2.getCp() : "");
				xml.append("</codPostal>");
				xml.append("<municipio>");
				xml.append((venvioOs2.getMunicipioempresa() != null) ? venvioOs2
						.getMunicipioempresa() : "");
				xml.append("</municipio>");
				xml.append("<telefono>");
				xml.append((venvioOs2.getTelefonoempresa() != null) ? venvioOs2
						.getTelefonoempresa() : "");
				xml.append("</telefono>");
				xml.append("<domicilioCentro>");
				xml.append((venvioOs2.getDireccioncentro() != null) ? venvioOs2
						.getDireccioncentro() : "");
				xml.append("</domicilioCentro>");
				xml.append("<numApertura>");
				xml.append((venvioOs2.getNumApertura() != null) ? venvioOs2
						.getNumApertura() : "");
				xml.append("</numApertura>");

				xml.append("<provinciaCast>");
				xml.append(datosMap.get("provinciaCast"));
				xml.append("</provinciaCast>");
				xml.append("<provinciaEusk>");
				xml.append(datosMap.get("provinciaEusk"));
				xml.append("</provinciaEusk>");
				xml.append("<ciudadCast>");
				xml.append(datosMap.get("ciudadCast"));
				xml.append("</ciudadCast>");
				xml.append("<ciudadEusk>");
				xml.append(datosMap.get("ciudadEusk"));
				xml.append("</ciudadEusk>");
				xml.append("<piePagina>");
				xml.append((venvioOs2.getPie1() != null) ? venvioOs2.getPie1()
						: "");
				xml.append("</piePagina>");
				xml.append("<piePagina2>");
				xml.append((venvioOs2.getPie2() != null) ? venvioOs2.getPie2()
						: "");
				xml.append("</piePagina2>");
				xml.append("<email>");
				xml.append((venvioOs2.getEmaemp() != null) ? venvioOs2
						.getEmaemp() : "");
				xml.append("</email>");
				xml.append("<fax>");
				xml.append((venvioOs2.getFaxemp() != null) ? venvioOs2
						.getFaxemp() : "");
				xml.append("</fax>");
				xml.append("</docOS2>");
			}
			xml.append("</impresiones>");
			return xml;
		} catch (Exception e) {
			throw new AB04BException(e, e.getMessage());
		}
	}

	/**
	 * /** Devuelve el objeto ficha apertura con los datos.
	 * 
	 *  pkFicha
	 *            String
	 *  VenvioOs2
	 *
	 * @param pkFicha the pk ficha
	 * @return the venvio os 2
	 */
	private VenvioOs2 obtenerVenvioOs2(String pkFicha) {
		String numExp = "";
		String anio = "";
		int numero = 0;
		String territorio = "";
		VenvioOs2 venvioOs2 = new VenvioOs2();

		if (pkFicha.contains("~")) {
			StringTokenizer token = new StringTokenizer(pkFicha, "~");

			if (token.hasMoreTokens()) {
				territorio = (String) token.nextToken();
			}
			if (token.hasMoreTokens()) {
				anio = (String) token.nextToken();
			}
			if (token.hasMoreTokens()) {
				numero = Integer.parseInt((String) token.nextToken());
			}
			StringBuffer folderNumber = new StringBuffer();
			folderNumber.append(territorio).append("-");
			folderNumber.append(anio).append("-");
			folderNumber.append(numero);
			numExp = folderNumber.toString();
			venvioOs2.setNumexp(numExp);
		} else {
			numExp = pkFicha.replaceAll("/", "-");
			venvioOs2.setNumexp(numExp);
		}
		return this.venvioOs2Service.find(venvioOs2);
	}
}
